package gov.va.med.mhv.health.web.form.bean;

import gov.va.med.mhv.health.dto.VAAllergyDTO;
import gov.va.med.mhv.health.util.CommonUtility;

public class VAAllergy extends VAAllergyDTO implements Comparable<VAAllergy>{

	private static final long serialVersionUID = 6634257952121406661L;
	private String source ="VA";
	private String severity;
	private String diagnosed;
	
	public String getDisplayObservationDate() {
		return  CommonUtility.dateToString(getObservationDate(), "MM/dd/yyyy");
	}
	
	public String getSource(){
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	@Override
	public int compareTo(VAAllergy o) {
		return o.getReactant().compareTo(this.getReactant());
	}

	public String getSeverity() {
		return severity;
	}

	public void setSeverity(String severity) {
		this.severity = severity;
	}

	public String getDiagnosed() {
		return diagnosed;
	}

	public void setDiagnosed(String diagnosed) {
		this.diagnosed = diagnosed;
	}
	
	
}
